--[[
[en] The Branch table replaces the various functions used for branching in the
StepMania 4 default theme.
Lines with a single string (e.g. TitleMenu = "ScreenTitleMenu") are referenced
in the metrics as Branch.keyname.
If the line is a function, you'll have to use Branch.keyname() instead.
--]]

-- used for various SMOnline-enabled screens:
function SMOnlineScreen()
	for pn in ivalues(GAMESTATE:GetHumanPlayers()) do
		if not IsSMOnlineLoggedIn(pn) then
			return "ScreenSMOnlineLogin"
		end
	end
	return "ScreenNetRoom"
end

function SelectMusicOrCourse()
	if IsNetSMOnline() then
		return "ScreenNetSelectMusic"
	elseif GAMESTATE:IsCourseMode() then
		if getenv("PlayMode") == "Special" then
			return "ScreenQuestMode"
		else
			return "ScreenSelectCourseCustom"
		end;
	else
		if getenv("PlayMode") == "Easy" then
			return "ScreenSelectEasy"
		else
			return "ScreenSelectMusic"
		end
	end
end

function JumpToCredits()
	local song = SONGMAN:FindSong(OMES_SONG)
	if song then
		GAMESTATE:SetCurrentSong(song);
		GAMESTATE:SetCurrentPlayMode("PlayMode_Regular");
		GAMESTATE:SetCurrentStyle("Single");
		local steps = song:GetOneSteps('StepsType_Pump_Single', 0);
		GAMESTATE:SetCurrentSteps('PlayerNumber_P1',steps);
		GAMESTATE:ApplyGameCommand('mod,failoff',PLAYER_1);
		local can, reason = GAMESTATE:CanSafelyEnterGameplay()
		if can then
			return "ScreenGameplayBlank";
		else
			SCREENMAN:SystemMessage("Can't play credits! "..reason);
		end;
	else
		SCREENMAN:SystemMessage("Can't play credits! OMES_SONG is missing. Check SYSTEM_PARAMETERS.lua.");
	end;
	return "ScreenTitleMenu";
end;

-- functions used for Routine mode
function IsRoutine()
	return GAMESTATE:GetCurrentStyle() and GAMESTATE:GetCurrentStyle():GetStyleType() == "StyleType_TwoPlayersSharedSides"
end

Branch = {
	Init = function() return "ScreenInit" end,
	AfterInit = function()
		if GAMESTATE:GetCoinMode() == 'CoinMode_Home' then
			return Branch.TitleMenu()
		else
			return "ScreenLogo"
		end
	end,
	NoiseTrigger = function()
		local hour = Hour()
		return hour > 3 and hour < 6 and "ScreenNoise" or "ScreenInit"
	end,
	TitleMenu = function()
		-- home mode is the most assumed use of sm-ssc.
		if GAMESTATE:GetCoinMode() == "CoinMode_Home" then
			return "ScreenTitleMenu"
		end
		-- arcade junk:
		if GAMESTATE:GetCoinsNeededToJoin() > GAMESTATE:GetCoins() then
			-- if no credits are inserted, don't show the Join screen. SM4 has
			-- this as the initial screen, but that means we'd be stuck in a
			-- loop with ScreenInit. No good.
			return "ScreenTitleJoin"
		else
			return "ScreenTitleJoin"
		end
	end,
	StartGame = function()
		-- Check to see if there are 0 songs installed. Also make sure to check
		-- that the additional song count is also 0, because there is
		-- a possibility someone will use their existing StepMania simfile
		-- collection with sm-ssc via AdditionalFolders/AdditionalSongFolders.
		if SONGMAN:GetNumSongs() == 0 and SONGMAN:GetNumAdditionalSongs() == 0 then
			return "ScreenHowToInstallSongs"
		end
		if PROFILEMAN:GetNumLocalProfiles() >= 2 then
			return "ScreenSelectProfile"
		else
			if IsNetConnected() then
				return "ScreenSelectStyle"
			else
				if THEME:GetMetric("Common","AutoSetStyle") == false then
					return "ScreenSelectStyle"
				else
					return "ScreenSelectProfileCS"
				end
			end
		end
	end,
	OptionsEdit = function()
		-- Similar to above, don't let anyone in here with 0 songs.
		if SONGMAN:GetNumSongs() == 0 and SONGMAN:GetNumAdditionalSongs() == 0 then
			return "ScreenHowToInstallSongs"
		end
		return "ScreenOptionsEdit"
	end,
	AfterSelectStyle = function()
		if IsNetConnected() then
			ReportStyle()
			GAMESTATE:ApplyGameCommand("playmode,regular")
		end
		if IsNetSMOnline() then
			return SMOnlineScreen()
		end
		if IsNetConnected() then
			return "ScreenNetRoom"
		end
		return "ScreenProfileLoad"

		--return CHARMAN:GetAllCharacters() ~= nil and "ScreenSelectCharacter" or "ScreenGameInformation"
	end,
	--This function isn't used, AfterProfileLoad is used
	AfterSelectProfile = function()
		if ( THEME:GetMetric("Common","AutoSetStyle") == true ) then
			-- use SelectStyle in online...
			return IsNetConnected() and "ScreenSelectStyle" or "ScreenSelectPlayMode"
		else
			return "ScreenSelectStyle"
		end
	end,
	AfterProfileLoad = function()
		STORYDATA:LoadCurrentProgress(GAMESTATE:GetMasterPlayerNumber())
		return "ScreenSelectCharacterCS"
		--return "ScreenSelectPlayMode"
	end,
	
	--I'm not sure this is even used?
	AfterProfileSave = function()
		-- Might be a little too broken? -- Midiman
		if GAMESTATE:IsEventMode() then
			return SelectMusicOrCourse()
		elseif STATSMAN:GetCurStageStats():AllFailed() or GAMESTATE:GetSmallestNumStagesLeftForAnyHumanPlayer() <= 0 then
			return "ScreenGameOver"
		else
			return SelectMusicOrCourse()
		end
	end,
	GetGameInformationScreen = function()
		bTrue = PREFSMAN:GetPreference("ShowInstructions")
		return (bTrue and GoToMusic() or "ScreenGameInformation")
	end,
	AfterSMOLogin = SMOnlineScreen(),
	BackOutOfPlayerOptions = function()
		return SelectMusicOrCourse()
	end,
	BackOutOfStageInformation = function()
		return SelectMusicOrCourse()
	end,
	AfterSelectMusic = function()
		if SCREENMAN:GetTopScreen():GetGoToOptions() then
			return SelectFirstOptionsScreen()
		else
			return "ScreenStageInformation"
		end
	end,
	PlayerOptions = function()
		local pm = GAMESTATE:GetPlayMode()
		local restricted = { "PlayMode_Oni", "PlayMode_Rave",
			--"PlayMode_Battle" -- ??
		}
		local optionsScreen = "ScreenPlayerOptions"
		for i=1,#restricted do
			if restricted[i] == pm then
				optionsScreen = "ScreenPlayerOptionsRestricted"
			end
		end
		if SCREENMAN:GetTopScreen():GetGoToOptions() then
			return optionsScreen
		else
			return "ScreenStageInformation"
		end
	end,
	SongOptions = function()
		if SCREENMAN:GetTopScreen():GetGoToOptions() then
			return "ScreenSongOptions"
		else
			return "ScreenStageInformation"
		end
	end,
	GameplayScreen = function()
		return IsRoutine() and "ScreenGameplayShared" or "ScreenGameplay"
	end,
	AfterGameplay = function()
		-- pick an evaluation screen based on settings.
		if IsNetSMOnline() then
			return "ScreenNetEvaluation"
		else
			-- todo: account for courses etc?
			return "ScreenEvaluationNormal"
		end
	end,
	AfterEvaluation = function()
		if GAMESTATE:IsCourseMode() then
			return "ScreenProfileSave"
		else
			local maxStages = PREFSMAN:GetPreference("SongsPerPlay")
			local stagesLeft = GAMESTATE:GetSmallestNumStagesLeftForAnyHumanPlayer()
			local allFailed = STATSMAN:GetCurStageStats():AllFailed()
			local song = GAMESTATE:GetCurrentSong()

			if GAMESTATE:IsEventMode() or stagesLeft >= 1 then
				return "ScreenProfileSave"
			elseif song:IsLong() and maxStages <= 2 and stagesLeft < 1 and allFailed then
				return "ScreenProfileSaveSummary"
			elseif song:IsMarathon() and maxStages <= 3 and stagesLeft < 1 and allFailed then
				return "ScreenProfileSaveSummary"
			elseif maxStages >= 2 and stagesLeft < 1 and allFailed then
				return "ScreenProfileSaveSummary"
			elseif allFailed then
				return "ScreenProfileSaveSummary"
			else
				return "ScreenProfileSave"
			end
		end
	end,
	AfterProfileSave = function()
		if getenv("GameMode") == "adventure" then --What could go wrong
			return "ScreenCredits"
		end;
	
		-- Might be a little too broken? -- Midiman
		if GAMESTATE:IsEventMode() then
			return SelectMusicOrCourse()
		elseif STATSMAN:GetCurStageStats():AllFailed() then
			return GameOverOrContinue()
		elseif GAMESTATE:GetSmallestNumStagesLeftForAnyHumanPlayer() == 0 then
			if not GAMESTATE:IsCourseMode() then
				return "ScreenEvaluationSummary"
			else
				return GameOverOrContinue()
			end
		else
			return SelectMusicOrCourse()
		end
	end,
	AfterSummary = function()
		return "ScreenProfileSaveSummary"
	end,
	Network = function()
		return IsNetConnected() and "ScreenTitleMenu" or "ScreenTitleMenu"
	end,
 	AfterSaveSummary = function()

		--Check for high scores for people without USB or local profiles so they can enter a high score name.
		for pn in ivalues(GAMESTATE:GetEnabledPlayers()) do
			--Trace("Running high score check.")
			if not PROFILEMAN:IsPersistentProfile(pn) and PlayerAchievedAnyHighScores(pn) then
				return "ScreenEnterRankingName"
			end;
		end;
		return "ScreenGameOver"
	end,
}

--Handle adventure mode.
function AfterEvaluation()
	if getenv("GameMode") == "adventure" then
		if STATSMAN:GetCurStageStats():AllFailed() then
			return "ScreenProfileSaveFailed"
		else
			return "ScreenNonstopInterpreter"
		end;
	else
		return "ScreenProfileSave"
	end;
end

function storyChapterSelect(shouldSave)
	if shouldSave then
		STORYDATA:SaveCurrentProgress()
	end;
	if true then
		return "VNChapterSelectDebug"
	else
		return "VNChapterSelect"
	end;
end

function DebugOrRegularSelect(saveIfStoryMode)
	
	--If returning from story mode
	if saveIfStoryMode and getenv("GameMode") == "Story" then
		STORYDATA:SaveCurrentProgress()
	end;
	
	return "ScreenWarning"
end;

function SongOrStory()
	local course = _G.CurrentFakeCourse;
	local NumCourseEntries = #course:GetCourseEntries();
	
	--The stage you are about to enter. Which starts at 1.
	local n = _G.StageIndex;
	
	--If the player failed.
	if STATSMAN:GetCurStageStats():AllFailed() then
		return "ScreenGameOver";
	end;
	
	if n <= NumCourseEntries then
		
		local dir = course:GetCourseDir():sub(1, -5);
		
		--If 1 before the final stage, it means they're on the EX stage
		if (n == NumCourseEntries and NumCourseEntries == 5) or (n == NumCourseEntries-1 and NumCourseEntries > 5) then
			--Need to A all stages.
			if STATSMAN:GetWorstGrade() < 3 or _G.AlwaysAllowExtra then
				_G.StageType = 2;
			else
				return "ScreenStoryEnd";
			end;
		--And if they're on the final stage and there's six (or more) stages, then they're on the One More Extra Stage. I think.
		elseif n == NumCourseEntries and NumCourseEntries > 5 then
			--Need to AA all stages.
			if STATSMAN:GetWorstGrade() < 2 then
				_G.StageType = 3;
			else
				return "ScreenStoryEnd";
			end;
		--If they're after the OMES stage?
		elseif n > NumCourseEntries then
			return "ScreenStoryEnd";
		end
		
		--[[
		Set it before entering a new screen, since at this point we've determined
		that the player has passed and they're eligible for another song.
		]]
		setFCSong();
		if FILEMAN:DoesFileExist(dir.."/"..n..".lua") then
			SCREENMAN:SystemMessage("Entering stage "..n.." story.");
			return "ScreenStory"
		else
			if DoDebug then
				SCREENMAN:SystemMessage(dir.."/"..n..".lua not found, going to gameplay screen.");
			end;
			--Warn and Trace doesn't fucking work
			--Trace("Trying to enter ScreenStageInformation for next song. Current Stage: "..n);
			return "ScreenStageInformation"
		end;
	else
		return "ScreenCredits";
	end;
end;

function DebugJumpToRandomSong()
	while true do
		local song = SONGMAN:GetRandomSong()
		if song then
			Trace(song:GetTranslitFullTitle())
			if false then
				GAMESTATE:SetCurrentSong(song);
				GAMESTATE:SetCurrentPlayMode("PlayMode_Regular");
				GAMESTATE:SetCurrentStyle("Versus");
				for pn in {'PlayerNumber_P1','PlayerNumber_P2'} do
					GAMESTATE:JoinPlayer(pn);
					local steps = song:GetOneSteps('StepsType_Pump_Single', 'Difficulty_Easy');
					GAMESTATE:SetCurrentSteps(pn,steps);
					GAMESTATE:ApplyGameCommand('mod,failoff',pn);
				end;
			else
				GAMESTATE:JoinPlayer('PlayerNumber_P1');
				GAMESTATE:SetCurrentSong(song);
				GAMESTATE:SetCurrentPlayMode("PlayMode_Regular");
				GAMESTATE:SetCurrentStyle("Single");
				local steps = song:GetOneSteps('StepsType_Pump_Single', 'Difficulty_Easy');
				GAMESTATE:SetCurrentSteps('PlayerNumber_P1',steps);
				GAMESTATE:ApplyGameCommand('mod,failoff',PLAYER_1);
			end
			local can, reason = GAMESTATE:CanSafelyEnterGameplay()
			if can then
				return "ScreenGameplayDebugRandomSong";
			--else
			--	SCREENMAN:SystemMessage("Can't play credits! "..reason);
			end;
		end;
	end;
	return "ScreenTitleMenu";
end;
